/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.agraham.b4j.jdragdrop;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4j.objects.NodeWrapper;
import java.util.Map;
import java.util.Set;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;

@BA.Author(value="Andrew Graham")
@BA.Version(value=1.1f)
@BA.ShortName(value="DragAndDrop")
public class DragDrop {
    @BA.Hide
    public static final double version = 1.1;
    TransferMode mode;
    String[] dataid;
    Object[] dataobject;
    boolean startdrag;

    public double getVersion() {
        return 1.1;
    }

    public void LIBRARY_DOC() {
    }

    public void MakeDragSource(final BA bA, final Node node, String string) {
        final String string2 = string.toLowerCase();
        if (bA.subExists(string2 + "_dragdetected")) {
            node.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    DragDrop.this.startdrag = false;
                    bA.raiseEvent(node, string2 + "_dragdetected", AbsObjectWrapper.ConvertToWrapper(new NodeWrapper.MouseEventWrapper(), mouseEvent));
                    if (DragDrop.this.startdrag) {
                        Dragboard dragboard = node.startDragAndDrop(new TransferMode[]{DragDrop.this.mode});
                        for (int i = 0; i < DragDrop.this.dataid.length; ++i) {
                            DataFormat dataFormat = DataFormat.lookupMimeType((String)DragDrop.this.dataid[i]);
                            if (dataFormat == null) {
                                dataFormat = new DataFormat(new String[]{DragDrop.this.dataid[i]});
                            }
                            ClipboardContent clipboardContent = new ClipboardContent();
                            clipboardContent.put((Object)dataFormat, DragDrop.this.dataobject[i]);
                            dragboard.setContent((Map)clipboardContent);
                        }
                    }
                }
            });
        }
        if (bA.subExists(string2 + "_dragdone")) {
            node.setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent dragEvent) {
                    bA.raiseEvent(node, string2 + "_dragdone", AbsObjectWrapper.ConvertToWrapper(new DragEventWrapper(), dragEvent));
                }
            });
        }
    }

    public void SetDragModeAndData(TransferMode transferMode, String[] stringArray, Object[] objectArray) {
        this.mode = transferMode;
        this.dataid = stringArray;
        this.dataobject = objectArray;
        this.startdrag = true;
    }

    public void MakeDragTarget(final BA bA, final Node node, String string) {
        final String string2 = string.toLowerCase();
        if (bA.subExists(string2 + "_dragover")) {
            node.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent dragEvent) {
                    bA.raiseEvent(node, string2 + "_dragover", AbsObjectWrapper.ConvertToWrapper(new DragEventWrapper(), dragEvent));
                }
            });
        }
        if (bA.subExists(string2 + "_dragentered")) {
            node.setOnDragEntered((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent dragEvent) {
                    bA.raiseEvent(node, string2 + "_dragentered", AbsObjectWrapper.ConvertToWrapper(new DragEventWrapper(), dragEvent));
                }
            });
        }
        if (bA.subExists(string2 + "_dragexited")) {
            node.setOnDragExited((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent dragEvent) {
                    bA.raiseEvent(node, string2 + "_dragexited", AbsObjectWrapper.ConvertToWrapper(new DragEventWrapper(), dragEvent));
                }
            });
        }
        if (bA.subExists(string2 + "_dragdropped")) {
            node.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent dragEvent) {
                    bA.raiseEvent(node, string2 + "_dragdropped", AbsObjectWrapper.ConvertToWrapper(new DragEventWrapper(), dragEvent));
                }
            });
        }
    }

    @BA.ShortName(value="DragEvent")
    public static class DragEventWrapper
    extends NodeWrapper.EventWrapper<DragEvent> {
        public void AcceptTransferMode(TransferMode transferMode) {
            ((DragEvent)this.getObject()).acceptTransferModes(new TransferMode[]{transferMode});
        }

        public Object GetGestureSource() {
            return ((DragEvent)this.getObject()).getGestureSource();
        }

        public Object GetGestureTarget() {
            return ((DragEvent)this.getObject()).getGestureTarget();
        }

        public TransferMode GetTransferMode() {
            return ((DragEvent)this.getObject()).getTransferMode();
        }

        public void SetDropCompleted(boolean bl) {
            ((DragEvent)this.getObject()).setDropCompleted(bl);
        }

        public double getX() {
            return ((DragEvent)this.getObject()).getX();
        }

        public double getY() {
            return ((DragEvent)this.getObject()).getY();
        }

        public String[] GetDataIds() {
            Set set = ((DragEvent)this.getObject()).getDragboard().getContentTypes();
            DataFormat[] dataFormatArray = set.toArray(new DataFormat[0]);
            String[] stringArray = new String[dataFormatArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Set set2 = dataFormatArray[i].getIdentifiers();
                String[] stringArray2 = set2.toArray(new String[1]);
                String string = "";
                for (int j = 0; j < stringArray2.length; ++j) {
                    string = string + stringArray2[j] + ",";
                }
                stringArray[i] = string = string.substring(0, string.length() - 1);
            }
            return stringArray;
        }

        public Object GetDataObjectForId(String string) {
            DataFormat dataFormat = DataFormat.lookupMimeType((String)string);
            if (dataFormat == null) {
                dataFormat = new DataFormat(new String[]{string});
            }
            return ((DragEvent)this.getObject()).getDragboard().getContent(dataFormat);
        }
    }
}

