/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.streams.File;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

@BA.Version(value=1.1f)
@BA.ShortName(value="SFtp")
public class SFtpWrapper {
    private Session session;
    private ChannelSftp channel;
    private String password;
    private volatile int numberOfTasks;
    private ReentrantLock lock = new ReentrantLock(true);
    private int taskId;
    private JSch jsch;
    private BA ba;
    private String eventName;
    private MyUserInfo userInfo;
    private MyMonitor downloadProgress;
    private MyMonitor uploadProgress;

    public void Initialize(BA ba, String EventName, String Username, String Password, String Host, int Port) throws JSchException {
        this.password = Password;
        this.ba = ba;
        this.jsch = new JSch();
        this.session = this.jsch.getSession(Username, Host, Port);
        this.eventName = EventName.toLowerCase(BA.cul);
        this.userInfo = new MyUserInfo();
        this.session.setUserInfo(this.userInfo);
        if (ba.subExists(String.valueOf(this.eventName) + "_downloadprogress")) {
            this.downloadProgress = new MyMonitor("_downloadprogress", false);
        }
        if (ba.subExists(String.valueOf(this.eventName) + "_uploadprogress")) {
            this.uploadProgress = new MyMonitor("_uploadprogress", true);
        }
    }

    public void SetKnownHostsStore(String Dir, String FileName) throws JSchException {
        this.jsch.setKnownHosts(File.Combine(Dir, FileName));
    }

    public void SetPromptResult(boolean Result) {
        this.userInfo.cont(Result);
    }

    public void UploadFile(final BA ba, final String DeviceFolder, final String DeviceFile, final String ServerFilePath) {
        final int myTask = this.taskId++;
        ++this.numberOfTasks;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SFtpWrapper.this.lock.lock();
                try {
                    boolean success = true;
                    try {
                        SFtpWrapper.this.connectIfNeeded();
                        InputStream in = (InputStream)File.OpenInput(DeviceFolder, DeviceFile).getObject();
                        try {
                            if (SFtpWrapper.this.uploadProgress != null && DeviceFile != File.getDirAssets()) {
                                ((SFtpWrapper)SFtpWrapper.this).uploadProgress.max = File.Size(DeviceFolder, DeviceFile);
                            }
                            SFtpWrapper.this.channel.put(in, ServerFilePath, (SftpProgressMonitor)SFtpWrapper.this.uploadProgress);
                        }
                        finally {
                            in.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        success = false;
                        ba.setLastException(e);
                    }
                    if (SFtpWrapper.this.session != null) {
                        ba.raiseEventFromDifferentThread((Object)null, (Object)SFtpWrapper.this, myTask, String.valueOf(SFtpWrapper.this.eventName) + "_uploadcompleted", false, new Object[]{ServerFilePath, success});
                    }
                }
                finally {
                    SFtpWrapper.this.endOfTask();
                }
            }
        };
        BA.submitRunnable(runnable, this, myTask);
    }

    public void DeleteFile(String ServerFilePath) {
        this.SendCommand("delete", ServerFilePath, null);
    }

    public void GetCurrentPath() {
        this.SendCommand("pwd", null, null);
    }

    public void Rename(String OldPath, String NewPath) {
        this.SendCommand("rename", OldPath, NewPath);
    }

    public void Chmod(String Path2, String Permissions2) {
        this.SendCommand("chmod", String.valueOf(Integer.parseInt(Permissions2, 8)), Path2);
    }

    private void SendCommand(final String Command, final String Parameter1, final String Parameter2) {
        final int myTask = this.taskId++;
        ++this.numberOfTasks;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SFtpWrapper.this.lock.lock();
                try {
                    boolean success = true;
                    String reply = "";
                    try {
                        SFtpWrapper.this.connectIfNeeded();
                        String cmd = Command.toLowerCase(BA.cul);
                        if (cmd.equals("delete")) {
                            SFtpWrapper.this.channel.rm(Parameter1);
                        } else if (cmd.equals("pwd")) {
                            reply = SFtpWrapper.this.channel.pwd();
                        } else if (cmd.equals("rename")) {
                            SFtpWrapper.this.channel.rename(Parameter1, Parameter2);
                        } else if (cmd.equals("chmod")) {
                            SFtpWrapper.this.channel.chmod(Integer.parseInt(Parameter1), Parameter2);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        success = false;
                        SFtpWrapper.this.ba.setLastException(e);
                    }
                    if (SFtpWrapper.this.session != null) {
                        SFtpWrapper.this.ba.raiseEventFromDifferentThread((Object)null, (Object)SFtpWrapper.this, myTask, String.valueOf(SFtpWrapper.this.eventName) + "_commandcompleted", false, new Object[]{Command, success, reply});
                    }
                }
                finally {
                    SFtpWrapper.this.endOfTask();
                }
            }
        };
        BA.submitRunnable(runnable, this, myTask);
    }

    public void DownloadFile(final BA ba, final String ServerFilePath, final String DeviceFolder, final String DeviceFile) {
        final int myTask = this.taskId++;
        ++this.numberOfTasks;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SFtpWrapper.this.lock.lock();
                try {
                    boolean success = true;
                    try {
                        SFtpWrapper.this.connectIfNeeded();
                        OutputStream out = (OutputStream)File.OpenOutput(DeviceFolder, DeviceFile, false).getObject();
                        try {
                            SFtpWrapper.this.channel.get(ServerFilePath, out, (SftpProgressMonitor)SFtpWrapper.this.downloadProgress);
                        }
                        finally {
                            out.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        success = false;
                        ba.setLastException(e);
                    }
                    if (SFtpWrapper.this.session != null) {
                        ba.raiseEventFromDifferentThread((Object)null, (Object)SFtpWrapper.this, myTask, String.valueOf(SFtpWrapper.this.eventName) + "_downloadcompleted", false, new Object[]{ServerFilePath, success});
                    }
                }
                finally {
                    SFtpWrapper.this.endOfTask();
                }
            }
        };
        BA.submitRunnable(runnable, this, myTask);
    }

    public void List(final BA ba, final String ServerPath) {
        final int myTask = this.taskId++;
        ++this.numberOfTasks;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SFtpWrapper.this.lock.lock();
                try {
                    SFTPFileWrapper[] files;
                    SFTPFileWrapper[] dirs;
                    boolean success = true;
                    try {
                        SFtpWrapper.this.connectIfNeeded();
                        Vector all = SFtpWrapper.this.channel.ls(ServerPath);
                        int countFolders = 0;
                        for (ChannelSftp.LsEntry ff : all) {
                            if (!ff.getAttrs().isDir()) continue;
                            ++countFolders;
                        }
                        dirs = new SFTPFileWrapper[countFolders];
                        files = new SFTPFileWrapper[all.size() - countFolders];
                        int d1 = 0;
                        int f1 = 0;
                        int i = 0;
                        while (i < all.size()) {
                            SFTPFileWrapper w = (SFTPFileWrapper)AbsObjectWrapper.ConvertToWrapper(new SFTPFileWrapper(), all.get(i));
                            if (((ChannelSftp.LsEntry)all.get(i)).getAttrs().isDir()) {
                                dirs[d1++] = w;
                            } else {
                                files[f1++] = w;
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        success = false;
                        ba.setLastException(e);
                        dirs = new SFTPFileWrapper[]{};
                        files = new SFTPFileWrapper[]{};
                    }
                    if (SFtpWrapper.this.session != null) {
                        ba.raiseEventFromDifferentThread((Object)null, (Object)SFtpWrapper.this, myTask, String.valueOf(SFtpWrapper.this.eventName) + "_listcompleted", false, new Object[]{ServerPath, success, dirs, files});
                    }
                }
                finally {
                    SFtpWrapper.this.endOfTask();
                }
            }
        };
        BA.submitRunnable(runnable, this, myTask);
    }

    public void Activity_Resume() {
        if (this.userInfo != null && this.userInfo.prompt != null) {
            this.ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.eventName) + "_promptyesno", true, new Object[]{this.userInfo.prompt});
        }
    }

    public void Close() {
        int myTask = this.taskId++;
        if (this.session == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Session session = SFtpWrapper.this.session;
                synchronized (session) {
                    while (true) {
                        if (SFtpWrapper.this.numberOfTasks <= 0) {
                            try {
                                SFtpWrapper.this.CloseNow();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        try {
                            SFtpWrapper.this.session.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return;
                }
            }
        };
        BA.submitRunnable(runnable, this, myTask);
    }

    public void CloseNow() throws IOException {
        if (this.session == null) {
            return;
        }
        if (this.channel != null && this.channel.isConnected()) {
            this.channel.disconnect();
        }
        if (this.session.isConnected()) {
            this.session.disconnect();
        }
        this.userInfo.cont(false);
        this.session = null;
    }

    private void connectIfNeeded() throws JSchException {
        if (this.session == null) {
            throw new RuntimeException("SFtp should first be initialized.");
        }
        if (!this.session.isConnected()) {
            this.session.connect();
            this.channel = (ChannelSftp)this.session.openChannel("sftp");
            this.channel.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endOfTask() {
        this.lock.unlock();
        --this.numberOfTasks;
        if (this.session != null && this.numberOfTasks == 0) {
            Session session = this.session;
            synchronized (session) {
                this.session.notifyAll();
            }
        }
    }

    class MyMonitor
    implements SftpProgressMonitor {
        long max;
        private String src;
        private final String eventType;
        private int counter;
        private final boolean upload;

        public MyMonitor(String eventType, boolean upload) {
            this.eventType = eventType;
            this.upload = upload;
        }

        @Override
        public boolean count(long count) {
            this.counter = (int)((long)this.counter + count);
            if (!SFtpWrapper.this.ba.isActivityPaused()) {
                SFtpWrapper.this.ba.raiseEventFromDifferentThread((Object)SFtpWrapper.this, (Object)null, 0, String.valueOf(SFtpWrapper.this.eventName) + this.eventType, false, new Object[]{this.src, this.counter, this.max});
            }
            return true;
        }

        @Override
        public void end() {
        }

        @Override
        public void init(int op, String src, String dest, long max) {
            if (this.upload) {
                this.src = dest;
            } else {
                this.src = src;
                this.max = max;
            }
            this.counter = 0;
        }
    }

    class MyUserInfo
    implements UserInfo {
        private boolean result;
        private CountDownLatch cdl;
        String prompt;

        MyUserInfo() {
        }

        public void cont(boolean res) {
            this.result = res;
            if (this.cdl != null) {
                this.cdl.countDown();
            }
            this.prompt = null;
        }

        @Override
        public String getPassphrase() {
            return SFtpWrapper.this.password;
        }

        @Override
        public String getPassword() {
            return SFtpWrapper.this.password;
        }

        @Override
        public boolean promptPassphrase(String message) {
            return true;
        }

        @Override
        public boolean promptPassword(String message) {
            return true;
        }

        @Override
        public boolean promptYesNo(String message) {
            this.prompt = message;
            SFtpWrapper.this.ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(SFtpWrapper.this.eventName) + "_promptyesno", true, new Object[]{this.prompt});
            this.cdl = new CountDownLatch(1);
            try {
                if (!this.cdl.await(60L, TimeUnit.SECONDS)) {
                    this.result = false;
                }
                this.prompt = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.result;
        }

        @Override
        public void showMessage(String message) {
            SFtpWrapper.this.ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(SFtpWrapper.this.eventName) + "_showmessage", true, new Object[]{message});
        }
    }

    @BA.ShortName(value="SFtpEntry")
    public static class SFTPFileWrapper
    extends AbsObjectWrapper<ChannelSftp.LsEntry> {
        public String getName() {
            return ((ChannelSftp.LsEntry)this.getObject()).getFilename();
        }

        public long getTimestamp() {
            return (long)((ChannelSftp.LsEntry)this.getObject()).getAttrs().getMTime() * 1000L;
        }

        public long getSize() {
            return ((ChannelSftp.LsEntry)this.getObject()).getAttrs().getSize();
        }
    }
}

