/*
 * Decompiled with CFR 0.152.
 */
package flm.b4a.archiver;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.collections.Map;
import flm.b4a.archiver.TarEntry;
import flm.b4a.archiver.TarInputStream;
import flm.b4a.archiver.TarOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

@BA.Version(value=1.11f)
@BA.ShortName(value="Archiver")
@BA.Author(value="Fr\u00e9d\u00e9ric Leneuf-Magaud")
public class ArchiverForB4A {
    private int Buffer = 2048;
    private boolean TaskRunning = false;
    private int NbOfFiles = 0;
    private BA _ba;
    private String _eventName;

    private static String getFileLocation(String Dir, String FileName) {
        if (Dir.endsWith("/")) {
            return String.valueOf(Dir) + FileName;
        }
        return String.valueOf(Dir) + "/" + FileName;
    }

    public synchronized int TarFiles(BA ba, String inDir, String[] inFileNames, String outDir, String outArchiveName) throws Exception, IOException {
        if (this.TaskRunning) {
            Exception e = new Exception("A background task is already running. This library is not thread-safe and cannot run many tasks at once.");
            throw new Exception(e.toString());
        }
        this.TaskRunning = true;
        try {
            FileOutputStream dest = new FileOutputStream(ArchiverForB4A.getFileLocation(outDir, outArchiveName));
            TarOutputStream out = new TarOutputStream(new BufferedOutputStream(dest));
            this.NbOfFiles = 0;
            String[] stringArray = inFileNames;
            int n = inFileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fn = stringArray[n2];
                File f = new File(ArchiverForB4A.getFileLocation(inDir, fn));
                if (f.exists()) {
                    int count;
                    out.putNextEntry(new TarEntry(f, f.getName()));
                    BufferedInputStream origin = new BufferedInputStream(new FileInputStream(f));
                    byte[] data = new byte[this.Buffer];
                    while ((count = origin.read(data)) != -1) {
                        out.write(data, 0, count);
                    }
                    out.flush();
                    origin.close();
                    ++this.NbOfFiles;
                }
                ++n2;
            }
            out.close();
        }
        catch (Exception e) {
            this.TaskRunning = false;
            throw new IOException(e.toString());
        }
        this.TaskRunning = false;
        return this.NbOfFiles;
    }

    public synchronized int TarFolder(BA ba, String inDir, String outDir, String outArchiveName) throws Exception, IOException {
        if (this.TaskRunning) {
            Exception e = new Exception("A background task is already running. This library is not thread-safe and cannot run many tasks at once.");
            throw new Exception(e.toString());
        }
        this.TaskRunning = true;
        try {
            FileOutputStream dest = new FileOutputStream(ArchiverForB4A.getFileLocation(outDir, outArchiveName));
            TarOutputStream out = new TarOutputStream(new BufferedOutputStream(dest));
            this.NbOfFiles = 0;
            this.internalTarFolder(null, inDir, out);
            out.close();
        }
        catch (Exception e) {
            this.TaskRunning = false;
            throw new IOException(e.toString());
        }
        this.TaskRunning = false;
        return this.NbOfFiles;
    }

    public synchronized int TarGzFolder(BA ba, String inDir, String outDir, String outArchiveName) throws Exception, IOException {
        if (this.TaskRunning) {
            Exception e = new Exception("A background task is already running. This library is not thread-safe and cannot run many tasks at once.");
            throw new Exception(e.toString());
        }
        this.TaskRunning = true;
        String outTarFile = ArchiverForB4A.getFileLocation(outDir, String.valueOf(outArchiveName) + ".tar");
        try {
            try {
                FileOutputStream dest = new FileOutputStream(outTarFile);
                TarOutputStream out = new TarOutputStream(new BufferedOutputStream(dest));
                this.NbOfFiles = 0;
                this.internalTarFolder(null, inDir, out);
                out.close();
                this.TaskRunning = false;
                this.Gzip(ba, outDir, String.valueOf(outArchiveName) + ".tar", outDir);
            }
            catch (Exception e) {
                this.TaskRunning = false;
                throw new IOException(e.toString());
            }
        }
        finally {
            new File(outTarFile).delete();
        }
        this.TaskRunning = false;
        return this.NbOfFiles;
    }

    public synchronized void AsyncTarGzFolder(BA ba, String inDir, String outDir, String outArchiveName, String eventName) throws IOException {
        BA.submitRunnable(new Runnable(this, ba, inDir, outDir, outArchiveName, eventName){
            private /* synthetic */ ArchiverForB4A this$0;
            private final /* synthetic */ BA val$ba;
            private final /* synthetic */ String val$inDir;
            private final /* synthetic */ String val$outDir;
            private final /* synthetic */ String val$outArchiveName;
            private final /* synthetic */ String val$eventName;
            {
                this.this$0 = archiverForB4A;
                this.val$ba = bA;
                this.val$inDir = string;
                this.val$outDir = string2;
                this.val$outArchiveName = string3;
                this.val$eventName = string4;
            }

            @Override
            public final void run() {
                try {
                    int NoF = this.this$0.TarGzFolder(this.val$ba, this.val$inDir, this.val$outDir, this.val$outArchiveName);
                    this.val$ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.val$eventName.toLowerCase()) + "_targzdone", false, new Object[]{true, NoF});
                    return;
                }
                catch (Exception e) {
                    this.val$ba.setLastException(e);
                    this.val$ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.val$eventName.toLowerCase()) + "_targzdone", false, new Object[]{false, -1});
                    return;
                }
            }
        }, null, 0);
    }

    private synchronized void internalTarFolder(String parent, String path, TarOutputStream out) throws IOException {
        File f = new File(path);
        String[] files = f.list();
        if (files == null) {
            String[] stringArray = new String[1];
            files = stringArray;
            stringArray[0] = f.getName();
        }
        parent = parent == null ? (f.isFile() ? "" : String.valueOf(f.getName()) + "/") : String.valueOf(parent) + f.getName() + "/";
        int i = 0;
        while (i < files.length) {
            File fe = f;
            if (f.isDirectory()) {
                fe = new File(f, files[i]);
            }
            if (fe.isDirectory()) {
                String[] fl = fe.list();
                if (fl != null && fl.length != 0) {
                    this.internalTarFolder(parent, fe.getPath(), out);
                } else {
                    TarEntry entry = new TarEntry(fe, String.valueOf(parent) + files[i] + "/");
                    out.putNextEntry(entry);
                }
            } else {
                int count;
                out.putNextEntry(new TarEntry(fe, String.valueOf(parent) + files[i]));
                BufferedInputStream origin = new BufferedInputStream(new FileInputStream(fe));
                byte[] data = new byte[this.Buffer];
                while ((count = origin.read(data)) != -1) {
                    out.write(data, 0, count);
                }
                out.flush();
                origin.close();
                ++this.NbOfFiles;
            }
            ++i;
        }
    }

    public synchronized int UnTar(BA ba, String inDir, String inArchiveName, String outDir) throws Exception, IOException {
        if (this.TaskRunning) {
            Exception e = new Exception("A background task is already running. This library is not thread-safe and cannot run many tasks at once.");
            throw new Exception(e.toString());
        }
        this.TaskRunning = true;
        try {
            FileInputStream src = new FileInputStream(ArchiverForB4A.getFileLocation(inDir, inArchiveName));
            TarInputStream in = new TarInputStream(new BufferedInputStream(src));
            this.NbOfFiles = 0;
            this.internalUnTar(in, outDir);
            in.close();
        }
        catch (Exception e) {
            this.TaskRunning = false;
            throw new IOException(e.toString());
        }
        this.TaskRunning = false;
        return this.NbOfFiles;
    }

    public synchronized int UnTarGz(BA ba, String inDir, String inArchiveName, String outDir) throws Exception, IOException {
        if (this.TaskRunning) {
            Exception e = new Exception("A background task is already running. This library is not thread-safe and cannot run many tasks at once.");
            throw new Exception(e.toString());
        }
        this.TaskRunning = true;
        try {
            File zf = new File(ArchiverForB4A.getFileLocation(inDir, inArchiveName));
            TarInputStream in = new TarInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(zf))));
            this.NbOfFiles = 0;
            this.internalUnTar(in, outDir);
            in.close();
        }
        catch (Exception e) {
            this.TaskRunning = false;
            throw new IOException(e.toString());
        }
        this.TaskRunning = false;
        return this.NbOfFiles;
    }

    public synchronized void AsyncUnTarGz(BA ba, String inDir, String inArchiveName, String outDir, String eventName) throws IOException {
        BA.submitRunnable(new Runnable(this, ba, inDir, inArchiveName, outDir, eventName){
            private /* synthetic */ ArchiverForB4A this$0;
            private final /* synthetic */ BA val$ba;
            private final /* synthetic */ String val$inDir;
            private final /* synthetic */ String val$inArchiveName;
            private final /* synthetic */ String val$outDir;
            private final /* synthetic */ String val$eventName;
            {
                this.this$0 = archiverForB4A;
                this.val$ba = bA;
                this.val$inDir = string;
                this.val$inArchiveName = string2;
                this.val$outDir = string3;
                this.val$eventName = string4;
            }

            @Override
            public final void run() {
                try {
                    int NoF = this.this$0.UnTarGz(this.val$ba, this.val$inDir, this.val$inArchiveName, this.val$outDir);
                    this.val$ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.val$eventName.toLowerCase()) + "_untargzdone", false, new Object[]{true, NoF});
                    return;
                }
                catch (Exception e) {
                    this.val$ba.setLastException(e);
                    this.val$ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.val$eventName.toLowerCase()) + "_untargzdone", false, new Object[]{false, -1});
                    return;
                }
            }
        }, null, 0);
    }

    private synchronized void internalUnTar(TarInputStream tis, String destFolder) throws IOException {
        TarEntry entry;
        while ((entry = tis.getNextEntry()) != null) {
            int count;
            if (entry.isDirectory()) {
                new File(ArchiverForB4A.getFileLocation(destFolder, entry.getName())).mkdirs();
                continue;
            }
            int di = entry.getName().lastIndexOf(47);
            if (di != -1) {
                new File(ArchiverForB4A.getFileLocation(destFolder, entry.getName().substring(0, di))).mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(ArchiverForB4A.getFileLocation(destFolder, entry.getName()));
            BufferedOutputStream dest = new BufferedOutputStream(fos);
            byte[] data = new byte[this.Buffer];
            while ((count = tis.read(data)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            ++this.NbOfFiles;
        }
    }

    public synchronized void Gzip(BA ba, String inDir, String inFileName, String outDir) throws Exception, IOException {
        if (this.TaskRunning) {
            Exception e = new Exception("A background task is already running. This library is not thread-safe and cannot run many tasks at once.");
            throw new Exception(e.toString());
        }
        this.TaskRunning = true;
        try {
            int count;
            FileOutputStream dest = new FileOutputStream(ArchiverForB4A.getFileLocation(outDir, String.valueOf(inFileName) + ".gz"));
            GZIPOutputStream zos = new GZIPOutputStream(new BufferedOutputStream(dest));
            BufferedInputStream origin = new BufferedInputStream(new FileInputStream(ArchiverForB4A.getFileLocation(inDir, inFileName)));
            byte[] data = new byte[this.Buffer];
            while ((count = origin.read(data)) != -1) {
                zos.write(data, 0, count);
            }
            zos.flush();
            origin.close();
            zos.close();
        }
        catch (Exception e) {
            this.TaskRunning = false;
            throw new IOException(e.toString());
        }
        this.TaskRunning = false;
    }

    public synchronized void AsyncGzip(BA ba, String inDir, String inFileName, String outDir, String eventName) throws IOException {
        BA.submitRunnable(new Runnable(this, ba, inDir, inFileName, outDir, eventName){
            private /* synthetic */ ArchiverForB4A this$0;
            private final /* synthetic */ BA val$ba;
            private final /* synthetic */ String val$inDir;
            private final /* synthetic */ String val$inFileName;
            private final /* synthetic */ String val$outDir;
            private final /* synthetic */ String val$eventName;
            {
                this.this$0 = archiverForB4A;
                this.val$ba = bA;
                this.val$inDir = string;
                this.val$inFileName = string2;
                this.val$outDir = string3;
                this.val$eventName = string4;
            }

            @Override
            public final void run() {
                try {
                    this.this$0.Gzip(this.val$ba, this.val$inDir, this.val$inFileName, this.val$outDir);
                    this.val$ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.val$eventName.toLowerCase()) + "_gzipdone", false, new Object[]{true});
                    return;
                }
                catch (Exception e) {
                    this.val$ba.setLastException(e);
                    this.val$ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.val$eventName.toLowerCase()) + "_gzipdone", false, new Object[]{false});
                    return;
                }
            }
        }, null, 0);
    }

    public synchronized void UnGzip(BA ba, String inDir, String inArchiveName, String outDir) throws Exception, IOException {
        if (this.TaskRunning) {
            Exception e = new Exception("A background task is already running. This library is not thread-safe and cannot run many tasks at once.");
            throw new Exception(e.toString());
        }
        this.TaskRunning = true;
        try {
            int count;
            FileInputStream src = new FileInputStream(ArchiverForB4A.getFileLocation(inDir, inArchiveName));
            GZIPInputStream gzin = new GZIPInputStream(new BufferedInputStream(src));
            new File(outDir).mkdirs();
            String NewFileName = inArchiveName.substring(0, inArchiveName.lastIndexOf(46));
            FileOutputStream fos = new FileOutputStream(ArchiverForB4A.getFileLocation(outDir, NewFileName));
            BufferedOutputStream gzout = new BufferedOutputStream(fos);
            byte[] data = new byte[this.Buffer];
            while ((count = gzin.read(data)) != -1) {
                gzout.write(data, 0, count);
            }
            gzin.close();
            gzout.close();
        }
        catch (Exception e) {
            this.TaskRunning = false;
            throw new IOException(e.toString());
        }
        this.TaskRunning = false;
    }

    public synchronized void AsyncUnGzip(BA ba, String inDir, String inArchiveName, String outDir, String eventName) throws IOException {
        BA.submitRunnable(new Runnable(this, ba, inDir, inArchiveName, outDir, eventName){
            private /* synthetic */ ArchiverForB4A this$0;
            private final /* synthetic */ BA val$ba;
            private final /* synthetic */ String val$inDir;
            private final /* synthetic */ String val$inArchiveName;
            private final /* synthetic */ String val$outDir;
            private final /* synthetic */ String val$eventName;
            {
                this.this$0 = archiverForB4A;
                this.val$ba = bA;
                this.val$inDir = string;
                this.val$inArchiveName = string2;
                this.val$outDir = string3;
                this.val$eventName = string4;
            }

            @Override
            public final void run() {
                try {
                    this.this$0.UnGzip(this.val$ba, this.val$inDir, this.val$inArchiveName, this.val$outDir);
                    this.val$ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.val$eventName.toLowerCase()) + "_ungzipdone", false, new Object[]{true});
                    return;
                }
                catch (Exception e) {
                    this.val$ba.setLastException(e);
                    this.val$ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.val$eventName.toLowerCase()) + "_ungzipdone", false, new Object[]{false});
                    return;
                }
            }
        }, null, 0);
    }

    public synchronized int ZipFiles(BA ba, String inDir, String[] inFileNames, String outDir, String outArchiveName, String eventName) throws Exception, IOException {
        if (this.TaskRunning) {
            Exception e = new Exception("A background task is already running. This library is not thread-safe and cannot run many tasks at once.");
            throw new Exception(e.toString());
        }
        this.TaskRunning = true;
        try {
            FileOutputStream dest = new FileOutputStream(ArchiverForB4A.getFileLocation(outDir, outArchiveName));
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            this.NbOfFiles = 0;
            String[] stringArray = inFileNames;
            int n = inFileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fn = stringArray[n2];
                File f = new File(ArchiverForB4A.getFileLocation(inDir, fn));
                if (f.exists()) {
                    int count;
                    ZipEntry entry = new ZipEntry(f.getName());
                    out.putNextEntry(entry);
                    BufferedInputStream origin = new BufferedInputStream(new FileInputStream(f));
                    byte[] data = new byte[this.Buffer];
                    while ((count = origin.read(data)) != -1) {
                        out.write(data, 0, count);
                    }
                    out.flush();
                    out.closeEntry();
                    origin.close();
                    ++this.NbOfFiles;
                    ba.raiseEvent(null, String.valueOf(eventName.toLowerCase()) + "_zipprogression", this.NbOfFiles, entry.getName());
                }
                ++n2;
            }
            out.close();
        }
        catch (Exception e) {
            this.TaskRunning = false;
            throw new IOException(e.toString());
        }
        this.TaskRunning = false;
        return this.NbOfFiles;
    }

    public synchronized int ZipFolder(BA ba, String inDir, String outDir, String outArchiveName, String eventName) throws Exception, IOException {
        if (this.TaskRunning) {
            Exception e = new Exception("A background task is already running. This library is not thread-safe and cannot run many tasks at once.");
            throw new Exception(e.toString());
        }
        this.TaskRunning = true;
        try {
            FileOutputStream dest = new FileOutputStream(ArchiverForB4A.getFileLocation(outDir, outArchiveName));
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            this.NbOfFiles = 0;
            this._ba = ba;
            this._eventName = String.valueOf(eventName.toLowerCase()) + "_zipprogression";
            this.internalZipFolder(null, inDir, out);
            out.close();
        }
        catch (Exception e) {
            this.TaskRunning = false;
            throw new IOException(e.toString());
        }
        this.TaskRunning = false;
        return this.NbOfFiles;
    }

    private synchronized void internalZipFolder(String parent, String path, ZipOutputStream out) throws IOException {
        File f = new File(path);
        String[] files = f.list();
        if (files == null) {
            String[] stringArray = new String[1];
            files = stringArray;
            stringArray[0] = f.getName();
        }
        parent = parent == null ? (f.isFile() ? "" : String.valueOf(f.getName()) + "/") : String.valueOf(parent) + f.getName() + "/";
        int i = 0;
        while (i < files.length) {
            File fe = f;
            if (f.isDirectory()) {
                fe = new File(f, files[i]);
            }
            if (fe.isDirectory()) {
                String[] fl = fe.list();
                if (fl != null && fl.length != 0) {
                    this.internalZipFolder(parent, fe.getPath(), out);
                } else {
                    ZipEntry entry = new ZipEntry(String.valueOf(parent) + files[i] + "/");
                    out.putNextEntry(entry);
                }
            } else {
                int count;
                out.putNextEntry(new ZipEntry(String.valueOf(parent) + files[i]));
                BufferedInputStream origin = new BufferedInputStream(new FileInputStream(fe));
                byte[] data = new byte[this.Buffer];
                while ((count = origin.read(data)) != -1) {
                    out.write(data, 0, count);
                }
                out.flush();
                out.closeEntry();
                origin.close();
                ++this.NbOfFiles;
                this._ba.raiseEvent(null, this._eventName, this.NbOfFiles, String.valueOf(parent) + files[i]);
            }
            ++i;
        }
    }

    public synchronized void AsyncZipFiles(BA ba, String inDir, String[] inFileNames, String outDir, String outArchiveName, String eventName) throws IOException {
        BA.submitRunnable(new Runnable(this, ba, inDir, inFileNames, outDir, outArchiveName, eventName){
            private /* synthetic */ ArchiverForB4A this$0;
            private final /* synthetic */ BA val$ba;
            private final /* synthetic */ String val$inDir;
            private final /* synthetic */ String[] val$inFileNames;
            private final /* synthetic */ String val$outDir;
            private final /* synthetic */ String val$outArchiveName;
            private final /* synthetic */ String val$eventName;
            {
                this.this$0 = archiverForB4A;
                this.val$ba = bA;
                this.val$inDir = string;
                this.val$inFileNames = stringArray;
                this.val$outDir = string2;
                this.val$outArchiveName = string3;
                this.val$eventName = string4;
            }

            @Override
            public final void run() {
                try {
                    int NoF = this.this$0.ZipFiles(this.val$ba, this.val$inDir, this.val$inFileNames, this.val$outDir, this.val$outArchiveName, this.val$eventName);
                    this.val$ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.val$eventName.toLowerCase()) + "_zipdone", false, new Object[]{true, NoF});
                    return;
                }
                catch (Exception e) {
                    this.val$ba.setLastException(e);
                    this.val$ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.val$eventName.toLowerCase()) + "_zipdone", false, new Object[]{false, -1});
                    return;
                }
            }
        }, null, 0);
    }

    public synchronized void AsyncZipFolder(BA ba, String inDir, String outDir, String outArchiveName, String eventName) throws IOException {
        BA.submitRunnable(new Runnable(this, ba, inDir, outDir, outArchiveName, eventName){
            private /* synthetic */ ArchiverForB4A this$0;
            private final /* synthetic */ BA val$ba;
            private final /* synthetic */ String val$inDir;
            private final /* synthetic */ String val$outDir;
            private final /* synthetic */ String val$outArchiveName;
            private final /* synthetic */ String val$eventName;
            {
                this.this$0 = archiverForB4A;
                this.val$ba = bA;
                this.val$inDir = string;
                this.val$outDir = string2;
                this.val$outArchiveName = string3;
                this.val$eventName = string4;
            }

            @Override
            public final void run() {
                try {
                    int NoF = this.this$0.ZipFolder(this.val$ba, this.val$inDir, this.val$outDir, this.val$outArchiveName, this.val$eventName);
                    this.val$ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.val$eventName.toLowerCase()) + "_zipdone", false, new Object[]{true, NoF});
                    return;
                }
                catch (Exception e) {
                    this.val$ba.setLastException(e);
                    this.val$ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.val$eventName.toLowerCase()) + "_zipdone", false, new Object[]{false, -1});
                    return;
                }
            }
        }, null, 0);
    }

    public synchronized int UnZip(BA ba, String inDir, String inArchiveName, String outDir, String eventName) throws Exception, IOException {
        if (this.TaskRunning) {
            Exception e = new Exception("A background task is already running. This library is not thread-safe and cannot run many tasks at once.");
            throw new Exception(e.toString());
        }
        this.TaskRunning = true;
        try {
            File zf = new File(ArchiverForB4A.getFileLocation(inDir, inArchiveName));
            ZipInputStream in = new ZipInputStream(new BufferedInputStream(new FileInputStream(zf)));
            this.NbOfFiles = 0;
            new File(outDir).mkdirs();
            this._ba = ba;
            this._eventName = String.valueOf(eventName.toLowerCase()) + "_unzipprogression";
            this.internalUnZip(in, outDir);
            in.close();
        }
        catch (Exception e) {
            this.TaskRunning = false;
            throw new IOException(e.toString());
        }
        this.TaskRunning = false;
        return this.NbOfFiles;
    }

    public synchronized void AsyncUnZip(BA ba, String inDir, String inArchiveName, String outDir, String eventName) throws IOException {
        BA.submitRunnable(new Runnable(this, ba, inDir, inArchiveName, outDir, eventName){
            private /* synthetic */ ArchiverForB4A this$0;
            private final /* synthetic */ BA val$ba;
            private final /* synthetic */ String val$inDir;
            private final /* synthetic */ String val$inArchiveName;
            private final /* synthetic */ String val$outDir;
            private final /* synthetic */ String val$eventName;
            {
                this.this$0 = archiverForB4A;
                this.val$ba = bA;
                this.val$inDir = string;
                this.val$inArchiveName = string2;
                this.val$outDir = string3;
                this.val$eventName = string4;
            }

            @Override
            public final void run() {
                try {
                    int NoF = this.this$0.UnZip(this.val$ba, this.val$inDir, this.val$inArchiveName, this.val$outDir, this.val$eventName);
                    this.val$ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.val$eventName.toLowerCase()) + "_unzipdone", false, new Object[]{true, NoF});
                    return;
                }
                catch (Exception e) {
                    this.val$ba.setLastException(e);
                    this.val$ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.val$eventName.toLowerCase()) + "_unzipdone", false, new Object[]{false, -1});
                    return;
                }
            }
        }, null, 0);
    }

    private synchronized void internalUnZip(ZipInputStream zis, String destFolder) throws IOException {
        ZipEntry entry;
        while ((entry = zis.getNextEntry()) != null) {
            int count;
            if (entry.isDirectory()) {
                new File(ArchiverForB4A.getFileLocation(destFolder, entry.getName())).mkdirs();
                continue;
            }
            int di = entry.getName().lastIndexOf(47);
            if (di != -1) {
                new File(ArchiverForB4A.getFileLocation(destFolder, entry.getName().substring(0, di))).mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(ArchiverForB4A.getFileLocation(destFolder, entry.getName()));
            BufferedOutputStream dest = new BufferedOutputStream(fos);
            byte[] data = new byte[this.Buffer];
            while ((count = zis.read(data)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            ++this.NbOfFiles;
            this._ba.raiseEvent(null, this._eventName, this.NbOfFiles, ArchiverForB4A.getFileLocation(destFolder, entry.getName()));
        }
    }

    public synchronized int UnZipFiles(BA ba, String inDir, String inArchiveName, String outDir, String[] outFileNames, String eventName) throws Exception, IOException {
        if (this.TaskRunning) {
            Exception e = new Exception("A background task is already running. This library is not thread-safe and cannot run many tasks at once.");
            throw new Exception(e.toString());
        }
        this.TaskRunning = true;
        try {
            ZipEntry entry;
            File zf = new File(ArchiverForB4A.getFileLocation(inDir, inArchiveName));
            ZipInputStream in = new ZipInputStream(new BufferedInputStream(new FileInputStream(zf)));
            this.NbOfFiles = 0;
            new File(outDir).mkdirs();
            while ((entry = in.getNextEntry()) != null) {
                String[] stringArray = outFileNames;
                int n = outFileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String fn = stringArray[n2];
                    if (!entry.isDirectory() && entry.getName().compareTo(fn) == 0) {
                        int count;
                        int slashPos = entry.getName().lastIndexOf(47);
                        if (slashPos != -1) {
                            new File(ArchiverForB4A.getFileLocation(outDir, entry.getName().substring(0, slashPos))).mkdirs();
                        }
                        BufferedOutputStream dest = new BufferedOutputStream(new FileOutputStream(ArchiverForB4A.getFileLocation(outDir, entry.getName())));
                        byte[] data = new byte[this.Buffer];
                        while ((count = in.read(data)) != -1) {
                            dest.write(data, 0, count);
                        }
                        dest.flush();
                        dest.close();
                        ++this.NbOfFiles;
                        ba.raiseEvent(null, eventName, this.NbOfFiles, ArchiverForB4A.getFileLocation(outDir, entry.getName()));
                        break;
                    }
                    ++n2;
                }
                if (this.NbOfFiles == outFileNames.length) break;
            }
            in.close();
        }
        catch (Exception e) {
            this.TaskRunning = false;
            throw new IOException(e.toString());
        }
        this.TaskRunning = false;
        return this.NbOfFiles;
    }

    public synchronized void AsyncUnZipFiles(BA ba, String inDir, String inArchiveName, String outDir, String[] outFileNames, String eventName) throws IOException {
        BA.submitRunnable(new Runnable(this, ba, inDir, inArchiveName, outDir, outFileNames, eventName){
            private /* synthetic */ ArchiverForB4A this$0;
            private final /* synthetic */ BA val$ba;
            private final /* synthetic */ String val$inDir;
            private final /* synthetic */ String val$inArchiveName;
            private final /* synthetic */ String val$outDir;
            private final /* synthetic */ String[] val$outFileNames;
            private final /* synthetic */ String val$eventName;
            {
                this.this$0 = archiverForB4A;
                this.val$ba = bA;
                this.val$inDir = string;
                this.val$inArchiveName = string2;
                this.val$outDir = string3;
                this.val$outFileNames = stringArray;
                this.val$eventName = string4;
            }

            @Override
            public final void run() {
                try {
                    int NoF = this.this$0.UnZipFiles(this.val$ba, this.val$inDir, this.val$inArchiveName, this.val$outDir, this.val$outFileNames, this.val$eventName);
                    this.val$ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.val$eventName.toLowerCase()) + "_unzipdone", false, new Object[]{true, NoF});
                    return;
                }
                catch (Exception e) {
                    this.val$ba.setLastException(e);
                    this.val$ba.raiseEventFromDifferentThread((Object)null, (Object)null, 0, String.valueOf(this.val$eventName.toLowerCase()) + "_unzipdone", false, new Object[]{false, -1});
                    return;
                }
            }
        }, null, 0);
    }

    public synchronized Map ListZipEntries(BA ba, String inDir, String inArchiveName) throws Exception, IOException {
        if (this.TaskRunning) {
            Exception e = new Exception("A background task is already running. This library is not thread-safe and cannot run many tasks at once.");
            throw new Exception(e.toString());
        }
        this.TaskRunning = true;
        Map ListZip = new Map();
        try {
            ListZip.Initialize();
            ZipFile zf = new ZipFile(ArchiverForB4A.getFileLocation(inDir, inArchiveName));
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                long[] lArray = new long[3];
                long[] ZipInfo = lArray;
                lArray[0] = ze.getSize();
                ZipInfo[1] = ze.getCompressedSize();
                ZipInfo[2] = ze.getCrc();
                ListZip.Put(ze.getName(), ZipInfo);
            }
            zf.close();
        }
        catch (Exception e) {
            this.TaskRunning = false;
            throw new IOException(e.toString());
        }
        this.TaskRunning = false;
        return ListZip;
    }

    public synchronized int NumberOfZipEntries(String inDir, String inArchiveName) throws IOException {
        ZipFile zf = new ZipFile(ArchiverForB4A.getFileLocation(inDir, inArchiveName));
        int NoF = zf.size();
        zf.close();
        return NoF;
    }

    public synchronized int getBufferSize() {
        return this.Buffer;
    }

    public synchronized void setBufferSize(int Size) {
        this.Buffer = Size;
    }
}

