/*
 * Decompiled with CFR 0.152.
 */
package flm.b4a.archiver;

import anywheresoftware.b4a.BA;
import flm.b4a.archiver.Octal;
import flm.b4a.archiver.TarHeader;
import java.io.File;
import java.util.Date;

@BA.Hide
public class TarEntry {
    protected File file = null;
    protected TarHeader header = new TarHeader();

    private TarEntry() {
    }

    public TarEntry(File file, String entryName) {
        this();
        this.file = file;
        this.extractTarHeader(entryName);
    }

    public TarEntry(byte[] headerBuf) {
        this();
        this.parseTarHeader(headerBuf);
    }

    public boolean equals(TarEntry it) {
        return this.header.name.toString().equals(it.header.name.toString());
    }

    public boolean isDescendent(TarEntry desc) {
        return desc.header.name.toString().startsWith(this.header.name.toString());
    }

    public TarHeader getHeader() {
        return this.header;
    }

    public String getName() {
        return this.header.name.toString();
    }

    public void setName(String name) {
        this.header.name = new StringBuffer(name);
    }

    public int getUserId() {
        return this.header.userId;
    }

    public void setUserId(int userId) {
        this.header.userId = userId;
    }

    public int getGroupId() {
        return this.header.groupId;
    }

    public void setGroupId(int groupId) {
        this.header.groupId = groupId;
    }

    public String getUserName() {
        return this.header.userName.toString();
    }

    public void setUserName(String userName) {
        this.header.userName = new StringBuffer(userName);
    }

    public String getGroupName() {
        return this.header.groupName.toString();
    }

    public void setGroupName(String groupName) {
        this.header.groupName = new StringBuffer(groupName);
    }

    public void setIds(int userId, int groupId) {
        this.setUserId(userId);
        this.setGroupId(groupId);
    }

    public void setModTime(long time) {
        this.header.modTime = time / 1000L;
    }

    public void setModTime(Date time) {
        this.header.modTime = time.getTime() / 1000L;
    }

    public Date getModTime() {
        return new Date(this.header.modTime * 1000L);
    }

    public File getFile() {
        return this.file;
    }

    public long getSize() {
        return this.header.size;
    }

    public void setSize(long size) {
        this.header.size = size;
    }

    public boolean isDirectory() {
        if (this.file != null) {
            return this.file.isDirectory();
        }
        if (this.header != null) {
            if (this.header.linkFlag == 53) {
                return true;
            }
            if (this.header.name.toString().endsWith("/")) {
                return true;
            }
        }
        return false;
    }

    public void extractTarHeader(String entryName) {
        String name = entryName.replace(File.separatorChar, '/');
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        this.header.linkName = new StringBuffer("");
        this.header.name = new StringBuffer(name);
        if (this.file.isDirectory()) {
            this.header.mode = 16877;
            this.header.linkFlag = (byte)53;
            if (this.header.name.charAt(this.header.name.length() - 1) != '/') {
                this.header.name.append("/");
            }
            this.header.size = 0L;
        } else {
            this.header.mode = 33188;
            this.header.linkFlag = (byte)48;
            this.header.size = this.file.length();
        }
        this.header.modTime = this.file.lastModified() / 1000L;
        this.header.checkSum = 0;
        this.header.devMajor = 0;
        this.header.devMinor = 0;
    }

    public long computeCheckSum(byte[] buf) {
        long sum = 0L;
        int i = 0;
        while (i < buf.length) {
            sum += (long)(0xFF & buf[i]);
            ++i;
        }
        return sum;
    }

    public void writeEntryHeader(byte[] outbuf) {
        int offset = TarHeader.getNameBytes(this.header.name, outbuf, 0, 100);
        offset = Octal.getOctalBytes(this.header.mode, outbuf, offset, 8);
        offset = Octal.getOctalBytes(this.header.userId, outbuf, offset, 8);
        offset = Octal.getOctalBytes(this.header.groupId, outbuf, offset, 8);
        offset = Octal.getLongOctalBytes(this.header.size, outbuf, offset, 12);
        int csOffset = offset = Octal.getLongOctalBytes(this.header.modTime, outbuf, offset, 12);
        int c = 0;
        while (c < 8) {
            outbuf[offset++] = 32;
            ++c;
        }
        outbuf[offset++] = this.header.linkFlag;
        offset = TarHeader.getNameBytes(this.header.linkName, outbuf, offset, 100);
        offset = TarHeader.getNameBytes(this.header.magic, outbuf, offset, 8);
        offset = TarHeader.getNameBytes(this.header.userName, outbuf, offset, 32);
        offset = TarHeader.getNameBytes(this.header.groupName, outbuf, offset, 32);
        offset = Octal.getOctalBytes(this.header.devMajor, outbuf, offset, 8);
        offset = Octal.getOctalBytes(this.header.devMinor, outbuf, offset, 8);
        while (offset < outbuf.length) {
            outbuf[offset++] = 0;
        }
        Octal.getCheckSumOctalBytes(this.computeCheckSum(outbuf), outbuf, csOffset, 8);
    }

    public void parseTarHeader(byte[] bh) {
        this.header.name = TarHeader.parseName(bh, 0, 100);
        this.header.mode = (int)Octal.parseOctal(bh, 100, 8);
        this.header.userId = (int)Octal.parseOctal(bh, 108, 8);
        this.header.groupId = (int)Octal.parseOctal(bh, 116, 8);
        this.header.size = Octal.parseOctal(bh, 124, 12);
        this.header.modTime = Octal.parseOctal(bh, 136, 12);
        this.header.checkSum = (int)Octal.parseOctal(bh, 148, 8);
        this.header.linkFlag = bh[156];
        this.header.linkName = TarHeader.parseName(bh, 157, 100);
        this.header.magic = TarHeader.parseName(bh, 257, 8);
        this.header.userName = TarHeader.parseName(bh, 265, 32);
        this.header.groupName = TarHeader.parseName(bh, 297, 32);
        this.header.devMajor = (int)Octal.parseOctal(bh, 329, 8);
        this.header.devMinor = (int)Octal.parseOctal(bh, 337, 8);
    }
}

