/*
 * Decompiled with CFR 0.152.
 */
package flm.b4a.archiver;

import anywheresoftware.b4a.BA;
import flm.b4a.archiver.TarEntry;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

@BA.Hide
public class TarInputStream
extends FilterInputStream {
    private TarEntry currentEntry;
    private long currentFileSize = 0L;
    private long bytesRead = 0L;
    private boolean defaultSkip = false;

    public TarInputStream(InputStream in) {
        super(in);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int res = this.read(buf, 0, 1);
        if (res != -1) {
            return buf[0];
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int br;
        if (this.currentEntry != null) {
            if (this.currentFileSize == this.currentEntry.getSize()) {
                return -1;
            }
            if (this.currentEntry.getSize() - this.currentFileSize < (long)len) {
                len = (int)(this.currentEntry.getSize() - this.currentFileSize);
            }
        }
        if ((br = super.read(b, off, len)) != -1) {
            if (this.currentEntry != null) {
                this.currentFileSize += (long)br;
            }
            this.bytesRead += (long)br;
        }
        return br;
    }

    public TarEntry getNextEntry() throws IOException {
        this.closeCurrentEntry();
        byte[] header = new byte[512];
        byte[] theader = new byte[512];
        int tr = 0;
        while (tr < 512) {
            int res = this.read(theader, 0, 512 - tr);
            if (res < 0) break;
            System.arraycopy(theader, 0, header, tr, res);
            tr += res;
        }
        boolean eof = true;
        byte[] byArray = header;
        int n = header.length;
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != 0) {
                eof = false;
                break;
            }
            ++n2;
        }
        if (!eof) {
            this.currentEntry = new TarEntry(header);
        }
        return this.currentEntry;
    }

    protected void closeCurrentEntry() throws IOException {
        if (this.currentEntry != null) {
            if (this.currentEntry.getSize() > this.currentFileSize) {
                long bs = 0L;
                while (bs < this.currentEntry.getSize() - this.currentFileSize) {
                    long res = this.skip(this.currentEntry.getSize() - this.currentFileSize - bs);
                    if (res == 0L && this.currentEntry.getSize() - this.currentFileSize > 0L) {
                        throw new IOException("Possible tar file corruption");
                    }
                    bs += res;
                }
            }
            this.currentEntry = null;
            this.currentFileSize = 0L;
            this.skipPad();
        }
    }

    protected void skipPad() throws IOException {
        int extra;
        if (this.bytesRead > 0L && (extra = (int)(this.bytesRead % 512L)) > 0) {
            long bs = 0L;
            while (bs < (long)(512 - extra)) {
                long res = this.skip((long)(512 - extra) - bs);
                bs += res;
            }
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.defaultSkip) {
            long bs = super.skip(n);
            this.bytesRead += bs;
            return bs;
        }
        if (n <= 0L) {
            return 0L;
        }
        long left = n;
        byte[] sBuff = new byte[2048];
        while (left > 0L) {
            int res = this.read(sBuff, 0, (int)(left < 2048L ? left : 2048L));
            if (res < 0) break;
            left -= (long)res;
        }
        return n - left;
    }

    public boolean isDefaultSkip() {
        return this.defaultSkip;
    }

    public void setDefaultSkip(boolean defaultSkip) {
        this.defaultSkip = defaultSkip;
    }
}

